<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->belongsTo('App\Models\Status');
    }

    public function files()
    {
        return $this->morphMany('App\Models\File', 'model');
    }

    public function prority()
    {
        return $this->hasOne('App\Models\Priority');
    }

}